from visual import *

from mpmath.functions import *
from mpmath.elliptic import *


Npoints = 400
Nsteps = 20

graph = curve(x=arange(0,Npoints+1.0,1.0),y=0.0,radius=.2,color=color.white)

C = -.86
deltamx = -.45
m = .5
g = list()
diff = list()

dx = 40.0/Npoints

for x in xrange(Npoints):
    g.append(-x)
    diff.append(-1)

for n in xrange(Nsteps):
    for x in xrange(Npoints):
        value = 0
        diff[x] = C/(1+deltamx*jsn(g[x],m)**2)
        for y in xrange(x):
            value += diff[y]*dx
        g[x] = value
        
        graph.pos[x][1] = 5.0*float(g[x])
